#ifndef SST_SEP_ATP_HMAC_H
#define SST_SEP_ATP_HMAC_H

#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 12 12:56:19 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SST_SEP_ATP_Sym.h#1:incl:1
   *  \author taniam
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/*****************************************************************************
 * Function Name:
 *  SEPQA_CRYS_SST_DES
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 *    Test the connection between CRYS and the SSTfunctionality while using SST DES generated keys
 *    in the CRYS_SST module
 *   HMAC
 
 * Algorithm:
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Generate AES keys inside the SST by calling: CRYS_SST_KG_DES.
 *    4.    Read the Key from the SST by calling: SST_DESKeyRead.
 *    5.    Encrypt the data using CRYS and extracted data(key) by calling = CRYS_DES.
 *    6.    Decrypt the data using CRYS_SST by calling: CRYS_SST_DES.
 *    7.    Compare the decrypted result to the original+
 *    8.    Decrypt the data using CRYS_SST non-integrated function 
 *    9.    Compare the decrypted result to the original
 *    10.  Delete the DES key by calling: SST_DataDelete.
 *    11.  Close the authenticator by calling: SST_AuthenticationClose.
 *    12.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    13.  Close the transaction by calling: SST_TransactionClose.
 *    14.  Delete the session by calling: SST_SessionDelete.
 *******************************************************************************/    
DxError_t SEPQA_CRYS_SST_DES (void );

/*****************************************************************************
 * Function Name:
 *    SEPQA_CRYS_SST_HMAC
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 *    Test the connection between CRYS and the SSTfunctionality while using SST HMAC generated keys
 *    in the CRYS_SST module
 *
 * Algorithm:
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Generate AES keys inside the SST by calling: CRYS_SST_KG_HMAC.
 *    4.    Read the Key from the SST by calling: SST_HMACKeyRead.
 *    5.    HASH the data using CRYS and extracted data(key) by calling = CRYS_HMAC.
 *    6.    HASH the data using CRYS_SST by calling: CRYS_SST_HMAC.
 *    7.    Compare the HASH'd results to they need to be identical
 *    8.    HASH the data using CRYS_SST non-integrated functions 
 *    9.    Compare the HASH'd results to they need to be identical
 *    10.  Delete the HMAC key by calling: SST_DataDelete.
 *    11.  Close the authenticator by calling: SST_AuthenticationClose.
 *    12.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    13.  Close the transaction by calling: SST_TransactionClose.
 *    14.  Delete the session by calling: SST_SessionDelete.
 *******************************************************************************/ 
    
  DxError_t SEPQA_CRYS_SST_HMAC ( void );
/*****************************************************************************
 * Function Name:
 *  SEPQA_CRYS_SST_AES
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 *    Test the connection between CRYS and the SSTfunctionality while using SST AES generated keys
 *    in the CRYS_SST module
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Generate AES keys inside the SST by calling: CRYS_SST_KG_AES.
 *    4.    Read the Key from the SST by calling: SST_AESKeyRead.
 *    5.    Encrypt the data using CRYS and extracted data(key) by calling = CRYS_AES.
 *    6.    Decrypt the data using CRYS_SST by calling: CRYS_SST_AES.
 *    7.    Compare the decrypted result to the original
 *    8.    Decrypt the data using the CRYS_SST non-integrated function
 *    9.    Compare the decrypted result to the original
 *    10.  Delete the AES key by calling: SST_DataDelete.
 *    11.  Close the authenticator by calling: SST_AuthenticationClose.
 *    12.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    13.  Close the transaction by calling: SST_TransactionClose.
 *    14.  Delete the session by calling: SST_SessionDelete.
 *******************************************************************************/    
DxError_t SEPQA_CRYS_SST_AES ( void);

#ifdef __cplusplus
}


#endif

#endif